function getURLVar(key) {
	var value = [];

	var query = String(document.location).split('?');

	if (query[1]) {
		var part = query[1].split('&');

		for (i = 0; i < part.length; i++) {
			var data = part[i].split('=');

			if (data[0] && data[1]) {
				value[data[0]] = data[1];
			}
		}

		if (value[key]) {
			return value[key];
		} else {
			return '';
		}
	}
}

$(document).ready(function() {
	$('#button-filter').on('click', function() {
		var url = 'index.php?route=tool/seo_manager&user_token=' + getURLVar('user_token');
		
		var filter_query = $('input[name=\'filter_query\']').val();

		if (filter_query) {
			url += '&filter_query=' + encodeURIComponent(filter_query);
		}

		var filter_keyword = $('input[name=\'filter_keyword\']').val();

		if (filter_keyword) {
			url += '&filter_keyword=' + encodeURIComponent(filter_keyword);
		}

		var filter_store_id = $('select[name=\'filter_store_id\']').val();

		if (filter_store_id) {
			url += '&filter_store_id=' + encodeURIComponent(filter_store_id);
		}
		
		var filter_language_id = $('select[name=\'filter_language_id\']').val();

		if (filter_language_id) {
			url += '&filter_language_id=' + encodeURIComponent(filter_language_id);
		}

		location = url;
	});
	
	$('input[name=\'filter_query\']').autocomplete({
		'source': function(request, response) {
			$.ajax({
				url: 'index.php?route=tool/seo_manager/autocomplete&user_token=' + getURLVar('user_token') + '&filter_query=' +  encodeURIComponent(request),
				dataType: 'json',
				success: function(json) {
					response($.map(json, function(item) {
						return {
							label: item['query'],
							value: item['seo_url_id']
						}
					}));
				}
			});
		},
		'select': function(item) {
			$('input[name=\'filter_query\']').val(item['label']);
		}
	});

	$('input[name=\'filter_keyword\']').autocomplete({
		'source': function(request, response) {
			$.ajax({
				url: 'index.php?route=tool/seo_manager/autocomplete&user_token=' + getURLVar('user_token') + '&filter_keyword=' +  encodeURIComponent(request),
				dataType: 'json',
				success: function(json) {
					response($.map(json, function(item) {
						return {
							label: item['keyword'],
							value: item['seo_url_id']
						}
					}));
				}
			});
		},
		'select': function(item) {
			$('input[name=\'filter_keyword\']').val(item['label']);
		}
	});
});

function editQuery(seo_url_id) {
	var query = $('#input-url-query' + seo_url_id).val();						
							
	$.ajax({
		url: 'index.php?route=tool/seo_manager/editQuery&user_token=' + getURLVar('user_token') + '&seo_url_id=' + seo_url_id + '&query=' + query,
		dataType: 'json',
		success: function(json) {									
			if (json['error']) {								
				$('.messages-body').html('<div class="alert alert-danger alert-messages"><i class="fa fa-check-circle"></i> ' + json['error'] + '</div>');$('.maxy-backdrop, .messages-body').show().delay(1500).fadeOut(500);
			}
									
			if (json['success']) {
				$('.messages-body').html('<div class="alert alert-success alert-messages"><i class="fa fa-check-circle"></i> ' + json['success'] + '</div>');$('.maxy-backdrop, .messages-body').show().delay(1000).fadeOut(500);			

				$('#url-query' + seo_url_id).html(query);

				$('#close-url-query-' + seo_url_id).trigger('click');
			}
		}
	});
}

function clearQuery(seo_url_id) {
	$('#input-url-query' + seo_url_id).val('');
}

function editKeyword(seo_url_id) {
	var keyword = $('#input-url-keyword' + seo_url_id).val();
	var query = $('#input-url-keyword-query' + seo_url_id).val();
	var keyword_none = $('#keyword-none').val();
							
	$.ajax({
		url: 'index.php?route=tool/seo_manager/editKeyword&user_token=' + getURLVar('user_token') + '&seo_url_id=' + seo_url_id + '&keyword=' + keyword + '&query=' + query,
		dataType: 'json',
		success: function(json) {									
			if (json['error']) {								
				$('.messages-body').html('<div class="alert alert-danger alert-messages"><i class="fa fa-check-circle"></i> ' + json['error'] + '</div>');$('.maxy-backdrop, .messages-body').show().delay(1500).fadeOut(500);
			}
									
			if (json['success']) {
				$('.messages-body').html('<div class="alert alert-success alert-messages"><i class="fa fa-check-circle"></i> ' + json['success'] + '</div>');$('.maxy-backdrop, .messages-body').show().delay(1000).fadeOut(500);			

				$('#url-keyword' + seo_url_id).html(keyword);
				
				if (keyword != '') {
					$('#url-keyword' + seo_url_id).html(keyword);
				} else {
					$('#url-keyword' + seo_url_id).html(keyword_none);
				}

				$('#close-url-keyword-' + seo_url_id).trigger('click');
			}
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
}

function clearKeyword(seo_url_id) {
	$('#input-url-keyword' + seo_url_id).val('');
	$('#input-url-keyword-query' + seo_url_id).val('');
}

function urlAlias(seo_url_id) {	
	$('#modal-url-alias').modal('show');
		
	$('#modal-url-alias').on('hide.bs.modal', function() {
		$('#modal-url-alias-content').empty();
	});
	
	if (seo_url_id) {
		$('#modal-url-alias-content').load('index.php?route=tool/seo_manager/urlAlias&user_token=' + getURLVar('user_token') + '&seo_url_id=' + seo_url_id);
	} else {
		$('#modal-url-alias-content').load('index.php?route=tool/seo_manager/urlAlias&user_token=' + getURLVar('user_token'));
	}
}

function generatorUrlAlias(generator) {	
	$('#modal-url-alias').modal('show');
		
	$('#modal-url-alias').on('hide.bs.modal', function() {
		$('#modal-url-alias-content').empty();
	});
	
	$('#modal-url-alias-content').load('index.php?route=tool/seo_manager/generator_' + generator + '&user_token=' + getURLVar('user_token'));
}

function generateSeoData(section, seo_type) {
	var seo_url = $('#form-seo-data input[id=\'template-seo-url\']').val();
	var overwrite = $('#form-seo-data select[id=\'input-overwrite\']').val();
	var language_id = $('#form-seo-data select[id=\'input-language\']').val();
	var meta_title = $('#form-seo-data input[id=\'template-meta-title\']').val();
	var meta_h1 = $('#form-seo-data input[id=\'template-meta-h1\']').val();
	var meta_description = $('#form-seo-data input[id=\'template-meta-description\']').val();
	var meta_keyword = $('#form-seo-data input[id=\'template-meta-keyword\']').val();
	var tag = $('#form-seo-data input[id=\'template-tag\']').val();
	
	$.ajax({
		url: 'index.php?route=tool/seo_manager/generateSeoData' + section + '&user_token=' + getURLVar('user_token') + '&seo_type=' + seo_type + '&seo_url=' + seo_url + '&language_id=' + language_id + '&meta_title=' + meta_title + '&meta_h1=' + meta_h1 + '&meta_description=' + meta_description + '&meta_keyword=' + meta_keyword + '&tag=' + tag + '&overwrite=' + overwrite,
		dataType: 'json',
		success: function(json) {									
			$('.alert-success, .alert-danger').remove();
			
			if (json['error']) {
				$('#form-seo-data').before('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + json['error'] + '</div>');
				
				$('.alert-danger').delay(2000).fadeOut(500);
			}
			
			if (json['success']) {
				$('#form-seo-data').before('<div class="alert alert-success"><i class="fa fa-exclamation-circle"></i> ' + json['success'] + '</div>');
				
				if (seo_type == 'seo_url') {
					setTimeout(function(){			
						location.reload(true);
					}, 500);
				} else {
					$('.alert-success').delay(2000).fadeOut(500);
				}
			}
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});	
}

function deleteSeoData(section, seo_type) {
	var confirm_delete = $('#delete-seo-confirm').val();
	
	if (!confirm(confirm_delete)) return;
	
	$.ajax({
		url: 'index.php?route=tool/seo_manager/deleteSeoData' + section + '&user_token=' + getURLVar('user_token') + '&seo_type=' + seo_type,
		dataType: 'json',
		success: function(json) {									
			$('.alert-success, .alert-danger').remove();
			
			if (json['error']) {
				$('#form-seo-data').before('<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> ' + json['error'] + '</div>');
				
				$('.alert-danger').delay(2000).fadeOut(500);
			}
				
			if (json['success']) {
				$('#form-seo-data').before('<div class="alert alert-success"><i class="fa fa-exclamation-circle"></i> ' + json['success'] + '</div>');
				
				$('.alert-success').delay(2000).fadeOut(500);
			}
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
}